#  JHS POWERBAR 2015   =  Credits Info for the Plaugins Authors at bottom of script   -   Max Coppoletta , Feb. 2015 


require 'sketchup'

module Max_Coppoletta
module JHS_powerbar

require 'sketchup.rb'
load 'jhs/_jhs_powerbar/jhs_powerbar.rb'

end	


#------------------------------------------------------------------------------
	module_function
	@dir=File.dirname(__FILE__)
	@strings = {}
		f=IO.readlines(File.join(@dir,"/jhs_pb.strings"))    # read translation strings
	n=0
	f.each do |l|
		l=l.strip.split("___")
		@strings[l.first]=l[1]
	end
#------------------------------------------------------------------------------	
	
	
	
	
	
 ######### MENUS ####################################################### 
  
  if !file_loaded?('jhs_menus_home')
    @@jhs_menus = UI.menu("Help").add_submenu("- CADFATHER PACK")
  end
    	
    @@jhs_menus.add_separator		
	
  if !file_loaded?(__FILE__)

    @@jhs_menus.add_item('POWERBAR ICONS...') { jhs_powerbar_toolbar }  # customise toolbar 
     jhs_powerbar_submenux = @@jhs_menus.add_submenu("POWERBAR...")


	

	
	
		jhs_powerbar_submenux.add_item('SOFTEN - SMOOTH')	{}		
		jhs_powerbar_submenux.add_separator
		

	jhs_powerbar_submenux.add_item(@strings['jhsm_pb00'])		{se = JHS_powerbar::JHS_AMS::SoftenEdges ; 	se.load_options ; 	se.show_dialog(true) ; 	se.soften_edges_from_selection	}	# AMS SMOOTH - SHOW DIALOG
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb01'])    { se = JHS_powerbar::JHS_AMS::SoftenEdges ;  se.load_options ;  JHS_AMS::SoftenEdges::soften_edges_from_selection }	# AMS SMOOTH - RUN AS OPTIONS	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb02'])    { JHS_powerbar::JHS_Soften.smooze 1 }	# SMOOZE LITE	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb03'])    { JHS_powerbar::JHS_Soften.smooze 2 }	#  SMOOZE HARD
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb04'])    { JHS_powerbar::JHS_Soften.smooze 3 }	#   UNSMOOZE
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb05'])    {	e = JHS_powerbar::JHS_AMS::SoftenEdges ; se.load_options ; JHS_powerbar::JHS_AMS::SoftenEdges::reveal_quadrants_from_selection }	  #    AMS SMOOTH - QUADRANT	
				
				
		jhs_powerbar_submenux.add_separator  
		jhs_powerbar_submenux.add_item('EXTRUDES')	{}		 #    SEPARATOR	
		jhs_powerbar_submenux.add_separator

	jhs_powerbar_submenux.add_item(@strings['jhsm_pb11'])    { Sketchup.active_model.select_tool(JHS_powerbar::JHS_EX::ExtrudeLineTool.new()) }		#  EXTRUDE LINES
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb12'])    { JHS_powerbar::extrude_along_path }	#    EXTRUDE ALONG PATH	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb13'])    { JHS_powerbar::JHS_PIP.pipe_along_path() }	#    PIPE ALONG PATH	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb14'])    { JHS_powerbar::tubeline2cyl }	#  LINES TO TUBES	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb06'])    { JHS_powerbar::JHS_Ene_uprightExtruder.userInput } 	# UPRIGHT EXTRUDER UPRIGHT		
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb07'])    { JHS_powerbar::JHS_Ene_uprightExtruder.setUpright } 	#  ENE UPRIGHT EXTRUDER INPUT BOX
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb08'])    { JHS_powerbar::JHS_Ene_uprightExtruder.setUptightFromEdge }		#   UPRIGHT EXTRUDER FROM EDGE
	
		jhs_powerbar_submenux.add_separator  
		jhs_powerbar_submenux.add_item('EDGE')	{}		 #    SEPARATOR	
		jhs_powerbar_submenux.add_separator
	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb09'])    { JHS_powerbar::JHS_IT_FF.ithil_facefinder }		#   FACE FINDER
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb10'])    { Sketchup.active_model.select_tool JHS_powerbar::JHS_SDMof::Offset_Edge.new }		#   OFFSET EDGE (GUIDE)

		jhs_powerbar_submenux.add_separator  
		jhs_powerbar_submenux.add_item('COMP-POSITIONS')	{}		 #    SEPARATOR	
		jhs_powerbar_submenux.add_separator	
	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb15'])   { Sketchup.active_model.select_tool JHS_powerbar::JHS_Smustard::PathCopy.new }	# PATHCOPY NEW	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb16'])   { JHS_powerbar::JHS_SDM_CS.maincs }	# COMP STRING - SDM COPY
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb17'])   { JHS_powerbar::jsAlign_red_centre  }		#   CENTRE ON RED	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb18'])   { JHS_powerbar::jsAlign_green_centre  }		#   CENTRE ON GREEN	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb19'])   { JHS_powerbar::jsAlign_blue_centre  }		#   CENTRE ON BLUE	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb20'])   { JHS_powerbar::JHS_SDM_CA.component_array }	# COMPONENT ARRAY (GRID)	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb43'])   { JHS_powerbar::insert_components_at_cpoints }	# COMPONENTS TO CPOINTS	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb21'])   { JHS_powerbar::JHS_drop::Drop.drop_intersection }		# DROP AT INTERSECTION
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb22'])   { JHS_powerbar::JHS_drop::Drop.drop_at } 	#   DROP AT	
	
	jhs_powerbar_submenux.add_separator	   #    SEPARATOR	

	jhs_powerbar_submenux.add_item(@strings['jhsm_pb23'])    { JHS_powerbar::JHS_MIR.Mirror_Tig }	# MIRROR	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb24'])    { JHS_powerbar::JHS_TIG_W::superwelder }	#  WELD	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb25'])     { JHS_powerbar::JHS_plode.plode() }	# EXPLODE CURVES
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb26'])     { JHS_powerbar::Equal_Segment_Curve.main }	# EQUAL SEGMENTS CURVE
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb27'])    { Sketchup.active_model.select_tool(JHS_powerbar::JHS_jsmover::MoveTool.new()) } 	#  JSMOVER		
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb28'])    { JHS_powerbar::Align.tool }	#  ALIGN TOOL	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb29'])    { Sketchup.active_model.select_tool JHS_powerbar::JHS_Ene3D::Tool3d.new }	#  3D ROTATE	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb30'])    { Sketchup.active_model.select_tool JHS_powerbar::Rotix.new }	#  3D ROTIX
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb31'])    { JHS_powerbar::JHS_sr::goscale }	#   RANDOM SCALE
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb32'])    { JHS_powerbar::JHS_sr::gorotate }	  #   RANDOM ROTATE
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb33'])    { JHS_powerbar::JHS_sr::goscalerotate }	  #   RANDOM	SCALE AND ROTATE
	jhs_powerbar_submenux.add_item("              ScaleRotate Settings") { JHS_powerbar::JHS_sr::defz ; JHS_powerbar::JHS_sr::settingz }

	jhs_powerbar_submenux.add_separator   #    SEPARATOR	
	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb34'])  {  JHS_powerbar::JHS_SDMpx::Proxify::goproxify  }	#   PROXIFY
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb35'])  { JHS_powerbar::JHS_swapz::Swapz::goswapify  }	#  SWAP COMPONENTS
	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb40'])   { JHS_powerbar::JHS_Mesh_Gen.mesh_maker }	#  MESH MAKER
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb41'])   { JHS_powerbar::JHS_Sub_Divide_Faces.main }	# SUBDIVIDE FACE
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb42'])    {JHS_powerbar::JHS_SplitUp.new()} 	  # TIG SPLITUP
	
		jhs_powerbar_submenux.add_separator  
		jhs_powerbar_submenux.add_item('GUIDES')	{}		 #    SEPARATOR	
		jhs_powerbar_submenux.add_separator	
	
	
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb44'])    { 	Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
																									JHS_powerbar::JHS_Connect_Guide_Points.main }    	# CONNECT GUIDE POINTS	
				
	jhs_powerbar_submenux.add_item(@strings['jhsm_pb43'])    {	Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
																									Sketchup.active_model.select_tool(JHS_powerbar::JHS_TIGvtx::AddVertexPoint.new())}	    # CPOINTS AT VERTEX	
				
	
	
##########################################   FFD


     jhs_powerbar2_submenux = jhs_powerbar_submenux.add_submenu("FREEFORM...")  
	 
	 
				
	jhs_powerbar2_submenux.add_item(@strings['jhsm_pb36'])    { 	Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
																									JHS_powerbar::JHS_SketchyFFD.startFFD(Sketchup.active_model.selection[0],[3,3,3],"false")}		# FFD 3X3X3	
				
	jhs_powerbar2_submenux.add_item(@strings['jhsm_pb37'])    { 	Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 	
																									prompts = ["Width: ","Depth: ","Height: ","Subdivide: "]
																									values = [@@w, @@d, @@h, @@s]
																									results = inputbox(prompts, values,["","","","true|false"], "FFD Dimensions")
																									if results
																									@@w,@@d,@@h,@@s=results
																									@@w=1 if @@w<1
																									@@d=1 if @@d<1
																									@@h=1 if @@h<1
																									JHS_powerbar::JHS_SketchyFFD.startFFD(Sketchup.active_model.selection[0],[@@w,@@d,@@h],@@s) 	  # FFD  INPUT
																									end }	
				
	jhs_powerbar2_submenux.add_item(@strings['jhsm_pb38'])    {	Sketchup.active_model.start_operation("Lock edges")
																									Sketchup.active_model.selection.each{|ent|
																									if ent.is_a?(Sketchup::Edge)
																									ent.vertices.each{|v| v.set_attribute("SFFD","locked",true)}
																									end}
																									Sketchup.active_model.commit_operation   }  		# FFD LOCK EDGES	
				
	jhs_powerbar2_submenux.add_item(@strings['jhsm_pb39'])    {	Sketchup.active_model.start_operation("Unlock edges")
																									Sketchup.active_model.selection.each{|ent|
																									if ent.is_a?(Sketchup::Edge)
																									ent.vertices.each{|v| v.set_attribute("SFFD","locked",false)}
																									end}
																									Sketchup.active_model.commit_operation  } 			# FFD UNLOCK EDGES	
	
	
##############################################################################################
	
	
	
#   CONTEXT MENUS   ##########################################



# menu = UI.menu('Edit')
  	  # menu.add_separator
	  # menu.add_separator
  # item = menu.add_item('- AMS Soften Edges'){
    # se.show_dialog( !se.dialog_visible? )
  # }
  # menu.set_validation_proc(item){
    # se.dialog_visible? ? MF_CHECKED : MF_UNCHECKED
  # }

  
  # UI.add_context_menu_handler do |context_menu|
    # context_menu.add_item('- AMS Soften Edges'){
      # se.show_dialog(true)
      # se.soften_edges_from_selection
    # }
	  # menu.add_separator
  # end



 ##############################    END OF CONTEXT MENU	
	
	

	
	# jhs_powerbar_submenux.add_separator
	# jhs_powerbar_submenux.add_item('# POWERBAR TOOLBAR...') { jhs_powerbar_toolbar }  # customise toolbar

   end   #    if !file_loaded?(__FILE__)
	

	file_loaded('Max_Coppoletta')
	file_loaded('jhs_menus_home')
  	file_loaded?(__FILE__)


##############################################################################################

	module_function
	@dir=File.dirname(__FILE__)
	@strings = {}
		f=IO.readlines(File.join(@dir,"/jhs_pb.strings"))    # read translation strings
	n=0
	f.each do |l|
		l=l.strip.split("___")
		@strings[l.first]=l[1]
	end

#     ############################################################################
	

def self.jhs_powerbar_toolbar
	puts 'Max_Coppoletta::JHS_powerbar.jhs_powerbar_toolbar'
	#Getting settings
	#jhs_pb_settings.txt in a file which contains all states of the checkboxes in the html file
	@dir=File.dirname(__FILE__)
	settings=IO.readlines(File.join(@dir,'/jhs_pb_settings.txt'))
	settings.each{|l|l.strip!}
	
	#To compare initial and future settings
	initial_settings=settings.dup
	
	#Create webdialog
	dial=UI::WebDialog.new(@strings['tm'], false, @strings['tm'],950,650,0,0, true)
	dial.set_file(File.join(@dir, "jhs_pb_tm.html"))
	
	#Here is the problem. I try to set all checkboxes with setting file. Each line correspond to a checkbox. 
	n=0
	if RUBY_PLATFORM.include?('darwin')
		dial.show_modal{
			for e in settings
				str="rubyCheck('c#{n}','#{e}')"
				dial.execute_script(str)
				n+=1
			end
		}
	else
		dial.show{
			for e in settings
				str="rubyCheck('c#{n}','#{e}')"
				dial.execute_script(str)
				n+=1
			end
		}
	end
	
	dial.add_action_callback("cback") {|dialog, params|
		case params
		#close webdialog when you click on "Cancel"
		when "stop"
			dial.close
		#Set settings file with the new settings when you click on "Ok"
		when "go"
			if settings!=initial_settings
				f=File.open(File.join(@dir,'/jhs_pb_settings.txt'),"w")
				for e in settings
					f.puts e
				end
				f.close
				UI.messagebox(@strings['atc'])
			else
				UI.messagebox(@strings['ntc'])
				
			end
			dial.close
		#When a checkbox is checked or unchecked
		when "0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45"
			n=params.to_i
			#reverse state od the checkbox in settings file
			if settings[n]=="true"
				settings[n]="false"
			else
				settings[n]="true"
			end
		end
	}
end     #   jhs_pb_toolbar

# ##############################################
	settings=IO.readlines(File.join(@dir,'/jhs_pb_settings.txt'))
	settings.each{|l|l.strip!}
	return if not settings.include?("true")
# ##############################################


		
		
=begin


														MENUS AND TOOLBARS
		
														
=end



######### MENU/TOOLBAR ###########

unless file_loaded?(__FILE__)
	jhs_pb_tb = UI::Toolbar.new("JHS PowerBar")
	
#------------------------------------------------------------------------------	
	n=0
	while n < settings.length
		if settings[n]=="true"
			case n
#------------------------------------------------------------------------------		

	
when 0 # AMS SMOOTH - SHOW DIALOG
				cmd00 = UI::Command.new(@strings['jhs_pb00']) {
					se = JHS_powerbar::JHS_AMS::SoftenEdges
				    se.load_options
				se.show_dialog(true)
				se.soften_edges_from_selection	}
				
				cmd00.small_icon = File.join(@dir, ("_ICONS/jhs_pb00_16.png"))
				cmd00.large_icon = File.join(@dir, ("_ICONS/jhs_pb00_24.png"))
				cmd00.tooltip =  "#{@strings['jhs_pb00']}"
				cmd00.status_bar_text = "#{@strings['jhs_pbt00']}"
				jhs_pb_tb.add_item (cmd00)

			
when 1 # AMS SMOOTH - RUN AS OPTIONS
				cmd01 = UI::Command.new(@strings['jhs_pb01'])   { 
					se = JHS_powerbar::JHS_AMS::SoftenEdges
				    se.load_options
				JHS_powerbar::JHS_AMS::SoftenEdges::soften_edges_from_selection }
				
				cmd01.small_icon = File.join(@dir, ("_ICONS/jhs_pb01_16.png"))
				cmd01.large_icon = File.join(@dir, ("_ICONS/jhs_pb01_24.png"))
				cmd01.tooltip =  "#{@strings['jhs_pb01']}"
				cmd01.status_bar_text = "#{@strings['jhs_pbt01']}"
				jhs_pb_tb.add_item (cmd01)

			
when 2 # SMOOZE LITE
				cmd02 = UI::Command.new(@strings['jhs_pb02'])   { JHS_powerbar::JHS_Soften.smooze 1 }
				cmd02.small_icon = File.join(@dir, ("_ICONS/jhs_pb02_16.png"))
				cmd02.large_icon = File.join(@dir, ("_ICONS/jhs_pb02_24.png"))
				cmd02.tooltip =  "#{@strings['jhs_pb02']}"
				cmd02.status_bar_text = "#{@strings['jhs_pbt02']}"
				jhs_pb_tb.add_item (cmd02)

			
when 3 #  SMOOZE HARD
				cmd03 = UI::Command.new(@strings['jhs_pb03'])  { JHS_powerbar::JHS_Soften.smooze 2 }
				cmd03.small_icon = File.join(@dir, ("_ICONS/jhs_pb03_16.png"))
				cmd03.large_icon = File.join(@dir, ("_ICONS/jhs_pb03_24.png"))
				cmd03.tooltip =  "#{@strings['jhs_pb03']}"
				cmd03.status_bar_text = "#{@strings['jhs_pbt03']}"
				jhs_pb_tb.add_item (cmd03)

			
when 4 #   UNSMOOZE
				cmd04 = UI::Command.new(@strings['jhs_pb04'])  { JHS_powerbar::JHS_Soften.smooze 3 }
				cmd04.small_icon = File.join(@dir, ("_ICONS/jhs_pb04_16.png"))
				cmd04.large_icon = File.join(@dir, ("_ICONS/jhs_pb04_24.png"))
				cmd04.tooltip =  "#{@strings['jhs_pb04']}"
				cmd04.status_bar_text = "#{@strings['jhs_pbt04']}"
				jhs_pb_tb.add_item (cmd04)

			
when 5 #    AMS SMOOTH - QUADRANT
				cmd05 = UI::Command.new(@strings['jhs_pb05'])   {
				  se = JHS_powerbar::JHS_AMS::SoftenEdges
				  se.load_options
				JHS_powerbar::JHS_AMS::SoftenEdges::reveal_quadrants_from_selection }
				cmd05.small_icon = File.join(@dir, ("_ICONS/jhs_pb05_16.png"))
				cmd05.large_icon = File.join(@dir, ("_ICONS/jhs_pb05_24.png"))
				cmd05.tooltip =  "#{@strings['jhs_pb05']}"
				cmd05.status_bar_text = "#{@strings['jhs_pbt05']}"
				jhs_pb_tb.add_item (cmd05)

			
#		jhs_pb_tb.add_separator

			
when 6 # UPRIGHT EXTRUDER UPRIGHT
				cmd06 = UI::Command.new(@strings['jhs_pb06']) { JHS_powerbar::JHS_Ene_uprightExtruder.userInput } 
				cmd06.small_icon = File.join(@dir, ("_ICONS/jhs_pb06_16.png"))
				cmd06.large_icon = File.join(@dir, ("_ICONS/jhs_pb06_24.png"))
				cmd06.tooltip =  "#{@strings['jhs_pb06']}"
				cmd06.status_bar_text = "#{@strings['jhs_pbt06']}"
				jhs_pb_tb.add_item (cmd06)

			
when 7 #  ENE UPRIGHT EXTRUDER INPUT BOX
				cmd07 = UI::Command.new(@strings['jhs_pb07'])  { JHS_powerbar::JHS_Ene_uprightExtruder.setUpright } 
				cmd07.small_icon = File.join(@dir, ("_ICONS/jhs_pb07_16.png"))
				cmd07.large_icon = File.join(@dir, ("_ICONS/jhs_pb07_24.png"))
				cmd07.tooltip =  "#{@strings['jhs_pb07']}"
				cmd07.status_bar_text = "#{@strings['jhs_pbt07']}"
				jhs_pb_tb.add_item (cmd07)

			
when 8 #   UPRIGHT EXTRUDER FROM EDGE
				cmd08 = UI::Command.new(@strings['jhs_pb08'])  { JHS_powerbar::JHS_Ene_uprightExtruder.setUptightFromEdge }
				cmd08.small_icon = File.join(@dir, ("_ICONS/jhs_pb08_16.png"))
				cmd08.large_icon = File.join(@dir, ("_ICONS/jhs_pb08_24.png"))
				cmd08.tooltip =  "#{@strings['jhs_pb08']}"
				cmd08.status_bar_text = "#{@strings['jhs_pbt08']}"
				jhs_pb_tb.add_item (cmd08)

			
when 9 #   FACE FINDER
				cmd09 = UI::Command.new(@strings['jhs_pb09'])  { JHS_powerbar::JHS_IT_FF.ithil_facefinder }
				cmd09.small_icon = File.join(@dir, ("_ICONS/jhs_pb09_16.png"))
				cmd09.large_icon = File.join(@dir, ("_ICONS/jhs_pb09_24.png"))
				cmd09.tooltip =  "#{@strings['jhs_pb09']}"
				cmd09.status_bar_text = "#{@strings['jhs_pbt09']}"
				jhs_pb_tb.add_item (cmd09)

			
when 10 #   OFFSET EDGE (GUIDE)
				cmd10 = UI::Command.new(@strings['jhs_pb10'])   { Sketchup.active_model.select_tool JHS_powerbar::JHS_SDMof::Offset_Edge.new }
				cmd10.small_icon = File.join(@dir, ("_ICONS/jhs_pb10_16.png"))
				cmd10.large_icon = File.join(@dir, ("_ICONS/jhs_pb10_24.png"))
				cmd10.tooltip =  "#{@strings['jhs_pb10']}"
				cmd10.status_bar_text = "#{@strings['jhs_pbt10']}"
				jhs_pb_tb.add_item (cmd10)

			
when 11 #  EXTRUDE LINE
				cmd11 = UI::Command.new(@strings['jhs_pb11'])  { Sketchup.active_model.select_tool(JHS_powerbar::JHS_EX::ExtrudeLineTool.new()) }
				cmd11.small_icon = File.join(@dir, ("_ICONS/jhs_pb11_16.png"))
				cmd11.large_icon = File.join(@dir, ("_ICONS/jhs_pb11_24.png"))
				cmd11.tooltip =  "#{@strings['jhs_pb11']}"
				cmd11.status_bar_text = "#{@strings['jhs_pbt11']}"
				jhs_pb_tb.add_item (cmd11)

			
when 12 #    EXTRUDE ALONG PATH
				cmd12 = UI::Command.new(@strings['jhs_pb12'])   { JHS_powerbar::JHSx.extrude_along_path }
				cmd12.small_icon = File.join(@dir, ("_ICONS/jhs_pb12_16.png"))
				cmd12.large_icon = File.join(@dir, ("_ICONS/jhs_pb12_24.png"))
				cmd12.tooltip =  "#{@strings['jhs_pb12']}"
				cmd12.status_bar_text = "#{@strings['jhs_pbt12']}"
				jhs_pb_tb.add_item (cmd12)

			
when 13 #    PIPE ALONG PATH
				cmd13 = UI::Command.new(@strings['jhs_pb13'])   { JHS_powerbar::JHS_PIP.pipe_along_path() }
				cmd13.small_icon = File.join(@dir, ("_ICONS/jhs_pb13_16.png"))
				cmd13.large_icon = File.join(@dir, ("_ICONS/jhs_pb13_24.png"))
				cmd13.tooltip =  "#{@strings['jhs_pb13']}"
				cmd13.status_bar_text = "#{@strings['jhs_pbt13']}"
				jhs_pb_tb.add_item (cmd13)

						
when 14 #  LINES TO TUBES
				cmd14 = UI::Command.new(@strings['jhs_pb14'])   { JHS_powerbar::tubeline2cyl }
				cmd14.small_icon = File.join(@dir, ("_ICONS/jhs_pb14_16.png"))
				cmd14.large_icon = File.join(@dir, ("_ICONS/jhs_pb14_24.png"))
				cmd14.tooltip =  "#{@strings['jhs_pb14']}"
				cmd14.status_bar_text = "#{@strings['jhs_pbt14']}"
				jhs_pb_tb.add_item (cmd14)

							
when 15 # PATHCOPY NEW
				cmd15 = UI::Command.new(@strings['jhs_pb15'])   { Sketchup.active_model.select_tool JHS_powerbar::JHS_Smustard::PathCopy.new }
				cmd15.small_icon = File.join(@dir, ("_ICONS/jhs_pb15_16.png"))
				cmd15.large_icon = File.join(@dir, ("_ICONS/jhs_pb15_24.png"))
				cmd15.tooltip =  "#{@strings['jhs_pb15']}"
				cmd15.status_bar_text = "#{@strings['jhs_pbt15']}"
				jhs_pb_tb.add_item (cmd15)


when 16 # COMP STRING - SDM COPY
				cmd16 = UI::Command.new(@strings['jhs_pb16'])   { JHS_powerbar::JHS_SDM_CS.maincs }
				cmd16.small_icon = File.join(@dir, ("_ICONS/jhs_pb16_16.png"))
				cmd16.large_icon = File.join(@dir, ("_ICONS/jhs_pb16_24.png"))
				cmd16.tooltip =  "#{@strings['jhs_pb16']}"
				cmd16.status_bar_text = "#{@strings['jhs_pbt16']}"
				jhs_pb_tb.add_item (cmd16)

			
when 17 # 	 CENTRE ON RED	
				cmd17 = UI::Command.new(@strings['jhs_pb17']) 		{ JHS_powerbar::jsAlign_red_centre  }		
				cmd17.small_icon = File.join(@dir, ("_ICONS/jhs_pb17_16.png"))
				cmd17.large_icon = File.join(@dir, ("_ICONS/jhs_pb17_24.png"))
				cmd17.tooltip =  "#{@strings['jhs_pb17']}"
				cmd17.status_bar_text = "#{@strings['jhs_pbt17']}"
				jhs_pb_tb.add_item (cmd17)

			
when 18 #   CENTRE ON GREEN
				cmd18 = UI::Command.new(@strings['jhs_pb18']) 		{ JHS_powerbar::jsAlign_green_centre  }	
				cmd18.small_icon = File.join(@dir, ("_ICONS/jhs_pb18_16.png"))
				cmd18.large_icon = File.join(@dir, ("_ICONS/jhs_pb18_24.png"))
				cmd18.tooltip = "#{@strings['jhs_pbt18']}"
				cmd18.status_bar_text = "#{@strings['jhs_pbt18']}"
				jhs_pb_tb.add_item (cmd18)

			
when 19 # CENTRE ON BLUE		
				cmd19 = UI::Command.new(@strings['jhs_pb19']) { JHS_powerbar::jsAlign_blue_centre  }	
				cmd19.small_icon = File.join(@dir, ("_ICONS/jhs_pb19_16.png"))
				cmd19.large_icon = File.join(@dir, ("_ICONS/jhs_pb19_24.png"))
				cmd19.tooltip =  "#{@strings['jhs_pb19']}"
				cmd19.status_bar_text = "#{@strings['jhs_pbt19']}"
				jhs_pb_tb.add_item (cmd19)	


when 20 # COMPONENT ARRAY (GRID)
				cmd20 = UI::Command.new(@strings['jhs_pb20'])  { JHS_powerbar::JHS_SDM_CA.component_array }
				cmd20.small_icon = File.join(@dir, ("_ICONS/jhs_pb20_16.png"))
				cmd20.large_icon = File.join(@dir, ("_ICONS/jhs_pb20_24.png"))
				cmd20.tooltip =  "#{@strings['jhs_pb20']}"
				cmd20.status_bar_text = "#{@strings['jhs_pbt20']}"
				jhs_pb_tb.add_item (cmd20)

			
when 21 # DROP AT INTERSECTION
				cmd21 = UI::Command.new(@strings['jhs_pb21'])   { JHS_powerbar::JHS_drop::Drop.drop_intersection }
				cmd21.small_icon = File.join(@dir, ("_ICONS/jhs_pb21_16.png"))
				cmd21.large_icon = File.join(@dir, ("_ICONS/jhs_pb21_24.png"))
				cmd21.tooltip =  "#{@strings['jhs_pb21']}"
				cmd21.status_bar_text = "#{@strings['jhs_pbt21']}"
				jhs_pb_tb.add_item (cmd21)

			
when 22 #   DROP AT
				cmd22 = UI::Command.new(@strings['jhs_pb22'])   { JHS_powerbar::JHS_drop::Drop.drop_at } 
				cmd22.small_icon = File.join(@dir, ("_ICONS/jhs_pb22_16.png"))
				cmd22.large_icon = File.join(@dir, ("_ICONS/jhs_pb22_24.png"))
				cmd22.tooltip =  "#{@strings['jhs_pb22']}"
				cmd22.status_bar_text = "#{@strings['jhs_pbt22']}"
				jhs_pb_tb.add_item (cmd22)

				
when 23 #  MIRROR
				cmd23 = UI::Command.new(@strings['jhs_pb23'])    { JHS_powerbar::JHS_MIR.Mirror_Tig }
				cmd23.small_icon = File.join(@dir, ("_ICONS/jhs_pb23_16.png"))
				cmd23.large_icon = File.join(@dir, ("_ICONS/jhs_pb23_24.png"))
				cmd23.tooltip =  "#{@strings['jhs_pb23']}"
				cmd23.status_bar_text = "#{@strings['jhs_pbt23']}"
				jhs_pb_tb.add_item (cmd23)
				
				

when 24 #   WELD
				cmd24 = UI::Command.new(@strings['jhs_pb24'])   { JHS_powerbar::JHS_TIG_W.superwelder }
				cmd24.small_icon = File.join(@dir, ("_ICONS/jhs_pb24_16.png"))
				cmd24.large_icon = File.join(@dir, ("_ICONS/jhs_pb24_24.png"))
				cmd24.tooltip =  "#{@strings['jhs_pb24']}"
				cmd24.status_bar_text = "#{@strings['jhs_pbt24']}"
				jhs_pb_tb.add_item (cmd24)	


when 25 #   EXPLODE CURVES
				cmd25 = UI::Command.new(@strings['jhs_pb25'])   { JHS_powerbar::JHS_plode.plode() }
				cmd25.small_icon = File.join(@dir, ("_ICONS/jhs_pb25_16.png"))
				cmd25.large_icon = File.join(@dir, ("_ICONS/jhs_pb25_24.png"))
				cmd25.tooltip =  "#{@strings['jhs_pb25']}"
				cmd25.status_bar_text = "#{@strings['jhs_pbt25']}"
				jhs_pb_tb.add_item (cmd25)	
				
				
when 26 # EQUAL SEGMENTS CURVE
				cmd26 = UI::Command.new(@strings['jhs_pb26'])  { JHS_powerbar::Equal_Segment_Curve.main }
				cmd26.small_icon = File.join(@dir, ("_ICONS/jhs_pb26_16.png"))
				cmd26.large_icon = File.join(@dir, ("_ICONS/jhs_pb26_24.png"))
				cmd26.tooltip =  "#{@strings['jhs_pb26']}"
				cmd26.status_bar_text = "#{@strings['jhs_pbt26']}"
				jhs_pb_tb.add_item (cmd26)
			
			
when 27 # 	JS MOVER
				cmd27 = UI::Command.new(@strings['jhs_pb27'])    { Sketchup.active_model.select_tool(JHS_powerbar::JHS_jsmover::MoveTool.new()) } 
				cmd27.small_icon = File.join(@dir, ("_ICONS/jhs_pb27_16.png"))
				cmd27.large_icon = File.join(@dir, ("_ICONS/jhs_pb27_24.png"))
				cmd27.tooltip =  "#{@strings['jhs_pb27']}"
				cmd27.status_bar_text = "#{@strings['jhs_pbt27']}"
				jhs_pb_tb.add_item (cmd27)

			
when 28 #  ALIGN TOOL
				cmd28 = UI::Command.new(@strings['jhs_pb28'])    { JHS_powerbar::Align.tool }
				cmd28.small_icon = File.join(@dir, ("_ICONS/jhs_pb28_16.png"))
				cmd28.large_icon = File.join(@dir, ("_ICONS/jhs_pb28_24.png"))
				cmd28.tooltip =  "#{@strings['jhs_pb28']}"
				cmd28.status_bar_text = "#{@strings['jhs_pbt28']}"
				jhs_pb_tb.add_item (cmd28)

			
when 29 #  3D ROTATE
				cmd29 = UI::Command.new(@strings['jhs_pb29'])   { Sketchup.active_model.select_tool JHS_powerbar::JHS_Ene3D::Tool3d.new }
				cmd29.small_icon = File.join(@dir, ("_ICONS/jhs_pb29_16.png"))
				cmd29.large_icon = File.join(@dir, ("_ICONS/jhs_pb29_24.png"))
				cmd29.tooltip =  "#{@strings['jhs_pb29']}"
				cmd29.status_bar_text = "#{@strings['jhs_pbt29']}"
				jhs_pb_tb.add_item (cmd29)

			
when 30 #  ROTIX
				cmd30 = UI::Command.new(@strings['jhs_pb30'])   { Sketchup.active_model.select_tool JHS_powerbar::Rotix.new }
				cmd30.small_icon = File.join(@dir, ("_ICONS/jhs_pb30_16.png"))
				cmd30.large_icon = File.join(@dir, ("_ICONS/jhs_pb30_24.png"))
				cmd30.tooltip =  "#{@strings['jhs_pb30']}"
				cmd30.status_bar_text = "#{@strings['jhs_pbt30']}"
				jhs_pb_tb.add_item (cmd30)

			
when 31 #   RANDOM SCALE ONLY
				cmd31 = UI::Command.new(@strings['jhs_pb31'])    	{ JHS_powerbar::JHS_sr::goscale }
 				cmd31.small_icon = File.join(@dir, ("_ICONS/jhs_pb31_16.png"))
				cmd31.large_icon = File.join(@dir, ("_ICONS/jhs_pb31_24.png"))
				cmd31.tooltip =  "#{@strings['jhs_pb31']}"
				cmd31.status_bar_text = "#{@strings['jhs_pbt31']}"
				jhs_pb_tb.add_item (cmd31)

			
when 32 #   RANDOM ROTATE ONLY
				cmd32 = UI::Command.new(@strings['jhs_pb32']) 		{ JHS_powerbar::JHS_sr::gorotate}
				cmd32.small_icon = File.join(@dir, ("_ICONS/jhs_pb32_16.png"))
				cmd32.large_icon = File.join(@dir, ("_ICONS/jhs_pb32_24.png"))
				cmd32.tooltip =  "#{@strings['jhs_pb32']}"
				cmd32.status_bar_text = "#{@strings['jhs_pbt32']}"
				jhs_pb_tb.add_item (cmd32)

			
when 33 #   RANDOM SCALE & ROTATE 
				cmd33 = UI::Command.new(@strings['jhs_pb33']) 	 { JHS_powerbar::JHS_sr::goscalerotate}
				cmd33.small_icon = File.join(@dir, ("_ICONS/jhs_pb33_16.png"))
				cmd33.large_icon = File.join(@dir, ("_ICONS/jhs_pb33_24.png"))
				cmd33.tooltip =  "#{@strings['jhs_pb33']}"
				cmd33.status_bar_text = "#{@strings['jhs_pbt33']}"
				jhs_pb_tb.add_item (cmd33)

			
when 34 #  PROXIFY
				cmd34 = UI::Command.new(@strings['jhs_pb34'])  {  JHS_powerbar::JHS_SDMpx::Proxify::goproxify  }
				cmd34.small_icon = File.join(@dir, ("_ICONS/jhs_pb34_16.png"))
				cmd34.large_icon = File.join(@dir, ("_ICONS/jhs_pb34_24.png"))
				cmd34.tooltip =  "#{@strings['jhs_pb34']}"
				cmd34.status_bar_text = "#{@strings['jhs_pbt34']}"
				jhs_pb_tb.add_item (cmd34)

			
when 35 #  SWAP COMPONENTS
				cmd35 = UI::Command.new(@strings['jhs_pb35']) 	{ JHS_powerbar::JHS_swapz::Swapz::goswapify  }	
				cmd35.small_icon = File.join(@dir, ("_ICONS/jhs_pb35_16.png"))
				cmd35.large_icon = File.join(@dir, ("_ICONS/jhs_pb35_24.png"))
				cmd35.tooltip =  "#{@strings['jhs_pb35']}"
				cmd35.status_bar_text = "#{@strings['jhs_pbt35']}"
				jhs_pb_tb.add_item (cmd35)

			
when 36 #  FFD 3X3X3
				cmd36 = UI::Command.new(@strings['jhs_pb36'])    { 
				Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
				JHS_powerbar::SketchyFFD.startFFD(Sketchup.active_model.selection[0],[3,3,3],"false")}	
				cmd36.small_icon = File.join(@dir, ("_ICONS/jhs_pb36_16.png"))
				cmd36.large_icon = File.join(@dir, ("_ICONS/jhs_pb36_24.png"))
				cmd36.tooltip = "#{@strings['jhs_pb36']}"
				cmd36.status_bar_text = "#{@strings['jhs_pbt36']}"
				jhs_pb_tb.add_item (cmd36)

			
when 37 # FFD 4x4x3
				cmd37 = UI::Command.new(@strings['jhs_pb37'])   { 
				Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 				
				JHS_powerbar::SketchyFFD.startFFD(Sketchup.active_model.selection[0],[4,4,3],"false") 	}	
				cmd37.small_icon = File.join(@dir, ("_ICONS/jhs_pb37_16.png"))
				cmd37.large_icon = File.join(@dir, ("_ICONS/jhs_pb37_24.png"))
				cmd37.tooltip =  "#{@strings['jhs_pb37']}"
				cmd37.status_bar_text = "#{@strings['jhs_pbt37']}"
				jhs_pb_tb.add_item (cmd37)

			
when 38 # FFD LOCK EDGES
				cmd38 = UI::Command.new(@strings['jhs_pb38'])    {
				Sketchup.active_model.start_operation("Lock edges")
				Sketchup.active_model.selection.each{|ent|
				if ent.is_a?(Sketchup::Edge)
				ent.vertices.each{|v| v.set_attribute("SFFD","locked",true)}
				end}
				Sketchup.active_model.commit_operation}  	
				cmd38.small_icon = File.join(@dir, ("_ICONS/jhs_pb38_16.png"))
				cmd38.large_icon = File.join(@dir, ("_ICONS/jhs_pb38_24.png"))
				cmd38.tooltip =  "#{@strings['jhs_pb38']}"
				cmd38.status_bar_text = "#{@strings['jhs_pbt38']}"
				jhs_pb_tb.add_item (cmd38)

			
when 39 # FFD UNLOCK EDGES
				cmd39 = UI::Command.new(@strings['jhs_pb39'])  {
				Sketchup.active_model.start_operation("Unlock edges")
				Sketchup.active_model.selection.each{|ent|
				if ent.is_a?(Sketchup::Edge)
				ent.vertices.each{|v| v.set_attribute("SFFD","locked",false)}
				end}
				Sketchup.active_model.commit_operation} 
				cmd39.small_icon = File.join(@dir, ("_ICONS/jhs_pb39_16.png"))
				cmd39.large_icon = File.join(@dir, ("_ICONS/jhs_pb39_24.png"))
				cmd39.tooltip =  "#{@strings['jhs_pb39']}"
				cmd39.status_bar_text = "#{@strings['jhs_pbt39']}"
				jhs_pb_tb.add_item (cmd39)

			
when 40 # MESH MAKER
				cmd40 = UI::Command.new(@strings['jhs_pb40'])  { JHS_powerbar::JHS_Mesh_Gen.mesh_maker }
				cmd40.small_icon = File.join(@dir, ("_ICONS/jhs_pb40_16.png"))
				cmd40.large_icon = File.join(@dir, ("_ICONS/jhs_pb40_24.png"))
				cmd40.tooltip = "#{@strings['jhs_pbt40']}"
				cmd40.status_bar_text = "#{@strings['jhs_pbt40']}"
				jhs_pb_tb.add_item (cmd40)

			
when 41 # SUBDIVIDE FACE  			
				cmd41 = UI::Command.new(@strings['jhs_pb41'])  { JHS_powerbar::JHS_Sub_Divide_Faces.main }  #  sdmitch sundivide
				cmd41.small_icon = File.join(@dir, ("_ICONS/jhs_pb41_16.png"))
				cmd41.large_icon = File.join(@dir, ("_ICONS/jhs_pb41_24.png"))
				cmd41.tooltip =  "#{@strings['jhs_pb41']}"
				cmd41.status_bar_text = "#{@strings['jhs_pbt41']}"
				jhs_pb_tb.add_item (cmd41)

				
			
when 42 # SPLIT UP	
				cmd42 = UI::Command.new(@strings['jhs_pb42'])  {JHS_powerbar::JHS_SplitUp.new()} 	  # tig splitup
				cmd42.small_icon = File.join(@dir, ("_ICONS/jhs_pb42_16.png"))
				cmd42.large_icon = File.join(@dir, ("_ICONS/jhs_pb42_24.png"))
				cmd42.tooltip =  "#{@strings['jhs_pb42']}"
				cmd42.status_bar_text = "#{@strings['jhs_pbt42']}"
				jhs_pb_tb.add_item (cmd42)		

			
when 43 # CPOINTS AT VERTEX
				cmd43 = UI::Command.new(@strings['jhs_pb43'])  {
				Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
				Sketchup.active_model.select_tool(JHS_powerbar::JHS_TIGvtx::AddVertexPoint.new())}
				cmd43.small_icon = File.join(@dir, ("_ICONS/jhs_pb43_16.png"))
				cmd43.large_icon = File.join(@dir, ("_ICONS/jhs_pb43_24.png"))
				cmd43.tooltip =  "#{@strings['jhs_pb43']}"
				cmd43.status_bar_text = "#{@strings['jhs_pbt43']}"
				jhs_pb_tb.add_item (cmd43)

when 44 # CONNECT GUIDE POINTS
				cmd44 = UI::Command.new(@strings['jhs_pb44'])   { 
				Sketchup.active_model.rendering_options["HideConstructionGeometry"] = false 
				JHS_powerbar::JHS_Connect_Guide_Points.main }
				cmd44.small_icon = File.join(@dir, ("_ICONS/jhs_pb44_16.png"))
				cmd44.large_icon = File.join(@dir, ("_ICONS/jhs_pb44_24.png"))
				cmd44.tooltip =  "#{@strings['jhs_pb44']}"
				cmd44.status_bar_text = "#{@strings['jhs_pbt44']}"
				jhs_pb_tb.add_item (cmd44)				
			
when 45 # COMPONENTS TO CPOINTS
				cmd45 = UI::Command.new(@strings['jhs_pb45']) 	 { JHS_powerbar::insert_components_at_cpoints }
				cmd45.small_icon = File.join(@dir, ("_ICONS/jhs_pb45_16.png"))
				cmd45.large_icon = File.join(@dir, ("_ICONS/jhs_pb45_24.png"))
				cmd45.tooltip = "#{@strings['jhs_pbt45']}"
				cmd45.status_bar_text = "#{@strings['jhs_pbt45']}"
				jhs_pb_tb.add_item (cmd45)

			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			
			

	
	
#------------------------------------------------------------------------------		
	end   #   case		
	end   #  if settings true
	n+=1
	end    # while
#------------------------------------------------------------------------------		
	
	
	
	state = jhs_pb_tb.get_last_state
	if state==TB_NEVER_SHOWN
		jhs_pb_tb.show 
	elsif state==TB_VISIBLE
		jhs_pb_tb.restore
	end
	
	
	
	
	
end    # unless file loaded toolbar
	file_loaded(__FILE__)	
	
end # Max_Coppoletta module

